package cn.gintone.utils;

import cn.gintone.dtoPt.*;
import cn.iocoder.yudao.module.system.controller.admin.auth.myVo.PtResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import java.util.HashMap;
import java.util.Map;

public class BasicInfoHttpUtils {

    /**
     * 从平台获取部门信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtDeptInfo>> getDeptInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);

        Map<String, Object> map = new HashMap<>();
        map.put("page", 1);
        map.put("pageSize", 10000);

        String jsonString = JSON.toJSONString(map);
        String rStr = MyHttpThreeUtils.postJson(url, headers, jsonString);
        PtResult<PtData<PtDeptInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtDeptInfo>>>() {});
        return result;
    }

    /**
     * 从平台获取人员信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtUserInfo>> getUserInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);

        Map<String, Object> map = new HashMap<>();
        map.put("page", 1);
        map.put("pageSize", 100000);

        String jsonString = JSON.toJSONString(map);

        String rStr = MyHttpThreeUtils.postJson(url, headers, jsonString);
        PtResult<PtData<PtUserInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtUserInfo>>>() {});
        return result;
    }

    /**
     * 获取泵站信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtBzInfo>> getBzInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtBzInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtBzInfo>>>() {});
        return result;
    }

    /**
     * 防控车辆信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtCarInfo>> getFKCLInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtCarInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtCarInfo>>>() {});
        return result;
    }

    /**
     * 摄像图信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtSXTInfo>> getSXTInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtSXTInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtSXTInfo>>>() {});
        return result;
    }

    /**
     * 易涝点设备信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtYLDInfo>> getYLDInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtYLDInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtYLDInfo>>>() {});
        return result;
    }

    /**
     * 管点设备信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtGdInfo>> getGDInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtGdInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtGdInfo>>>() {});
        return result;
    }

    /**
     * 井盖信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtJgInfo>> getJgInfo(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtJgInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtJgInfo>>>() {});
        return result;
    }


    /**
     * 获取平台菜单信息
     * @param url
     * @param appkey
     * @param pdToken
     * @return
     */
    public static PtResult<PtData<PtMenuInfo>> getPtMenu(String url, String appkey, String pdToken) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("appkey", appkey);
        headers.put("Authorization", pdToken);
        String rStr = MyHttpThreeUtils.postJson(url, headers, null);
        PtResult<PtData<PtMenuInfo>> result = JSON.parseObject(rStr, new TypeReference<PtResult<PtData<PtMenuInfo>>>() {});
        return result;
    }
}
