package cn.gintone.service;

import java.util.*;
import javax.validation.*;

import cn.gintone.controller.vo.WebReqConfListReqVO;
import cn.gintone.controller.vo.WebReqConfSaveReqVO;
import cn.gintone.entity.WebReqConfDO;

/**
 * web请求配置 Service 接口
 *
 * @author 安全系统管理
 */
public interface WebReqConfService {

    /**
     * 创建web请求配置
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createWebReqConf(@Valid WebReqConfSaveReqVO createReqVO);

    /**
     * 更新web请求配置
     *
     * @param updateReqVO 更新信息
     */
    void updateWebReqConf(@Valid WebReqConfSaveReqVO updateReqVO);

    /**
     * 删除web请求配置
     *
     * @param id 编号
     */
    void deleteWebReqConf(Long id);

    /**
     * 获得web请求配置
     *
     * @param id 编号
     * @return web请求配置
     */
    WebReqConfDO getWebReqConf(Long id);

    /**
     * 获得web请求配置列表
     *
     * @param listReqVO 查询条件
     * @return web请求配置列表
     */
    List<WebReqConfDO> getWebReqConfList(WebReqConfListReqVO listReqVO);


    Long myCreateWebReqConf(@Valid WebReqConfSaveReqVO createReqVO);
}