package cn.gintone.service;

import cn.gintone.controller.vo.SysAbbrePageReqVO;
import cn.gintone.controller.vo.SysAbbreSaveReqVO;
import cn.gintone.entity.SysAbbreDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import java.util.*;
import javax.validation.*;

/**
 * 系统简称 Service 接口
 *
 * @author 安全系统管理
 */
public interface SysAbbreService {

    /**
     * 创建系统简称
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createSysAbbre(@Valid SysAbbreSaveReqVO createReqVO);

    /**
     * 更新系统简称
     *
     * @param updateReqVO 更新信息
     */
    void updateSysAbbre(@Valid SysAbbreSaveReqVO updateReqVO);

    /**
     * 删除系统简称
     *
     * @param id 编号
     */
    void deleteSysAbbre(Long id);

    /**
     * 获得系统简称
     *
     * @param id 编号
     * @return 系统简称
     */
    SysAbbreDO getSysAbbre(Long id);

    /**
     * 获得系统简称分页
     *
     * @param pageReqVO 分页查询
     * @return 系统简称分页
     */
    PageResult<SysAbbreDO> getSysAbbrePage(SysAbbrePageReqVO pageReqVO);

}