package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.PtDeptInfoSaveReqVO;
import cn.gintone.controller.vo.PtUserInfoPageReqVO;
import cn.gintone.controller.vo.PtUserInfoSaveReqVO;
import cn.gintone.dal.PtUserInfoMapper;
import cn.gintone.dtoPt.PtData;
import cn.gintone.dtoPt.PtDeptInfo;
import cn.gintone.dtoPt.PtUserInfo;
import cn.gintone.entity.PtUserInfoDO;
import cn.gintone.myconf.BasicUrlConf;
import cn.gintone.utils.BasicInfoHttpUtils;
import cn.iocoder.yudao.module.system.controller.admin.auth.myVo.PtResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;


import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 平台用户 Service 实现类
 *
 * @author 安全系统管理
 */
@Service
@Validated
public class PtUserInfoServiceImpl implements PtUserInfoService {

    @Resource
    private BasicUrlConf basicUrlConf;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private PtUserInfoMapper ptUserInfoMapper;

    @Override
    public Long createPtUserInfo(PtUserInfoSaveReqVO createReqVO) {
        // 插入
        PtUserInfoDO ptUserInfo = BeanUtils.toBean(createReqVO, PtUserInfoDO.class);
        ptUserInfoMapper.insert(ptUserInfo);
        // 返回
        return ptUserInfo.getId();
    }

    @Override
    public void updatePtUserInfo(PtUserInfoSaveReqVO updateReqVO) {
        // 校验存在
        validatePtUserInfoExists(updateReqVO.getId());
        // 更新
        PtUserInfoDO updateObj = BeanUtils.toBean(updateReqVO, PtUserInfoDO.class);
        ptUserInfoMapper.updateById(updateObj);
    }

    @Override
    public void deletePtUserInfo(Long id) {
        // 校验存在
        validatePtUserInfoExists(id);
        // 删除
        ptUserInfoMapper.deleteById(id);
    }

    private void validatePtUserInfoExists(Long id) {
        if (ptUserInfoMapper.selectById(id) == null) {
            throw exception(ErrorInfo.PT_USER_INFO_NOT_EXISTS);
        }
    }

    @Override
    public PtUserInfoDO getPtUserInfo(Long id) {
        return ptUserInfoMapper.selectById(id);
    }

    @Override
    public PageResult<PtUserInfoDO> getPtUserInfoPage(PtUserInfoPageReqVO pageReqVO) {
        return ptUserInfoMapper.selectPage(pageReqVO);
    }

    @Override
    public String syncPtUser() {
        String pdToken = stringRedisTemplate.opsForValue().get("pdToken");
        PtResult<PtData<PtUserInfo>> result = BasicInfoHttpUtils.getUserInfo(basicUrlConf.getUserInfoUrl(), "secure", pdToken);
        PtData<PtUserInfo> data = result.getData();
        List<PtUserInfo> rowData = data.getRowData();
        if (rowData != null && rowData.size() > 0) {
            for (PtUserInfo ptUserInfo : rowData) {
                PtUserInfoSaveReqVO createReqVO = new PtUserInfoSaveReqVO();
                createReqVO.setUserId(ptUserInfo.getU_id());
                createReqVO.setUserName(ptUserInfo.getU_name());
                createReqVO.setUserRealName(ptUserInfo.getU_real_name());
                createReqVO.setOrgId(ptUserInfo.getOrg_id());
                createReqVO.setOrgName(ptUserInfo.getOrg_name());

                PtUserInfoDO ptUserInfoDO = ptUserInfoMapper.selectOne(new QueryWrapper<PtUserInfoDO>()
                        .lambda()
                        .eq(PtUserInfoDO::getUserId, createReqVO.getUserId())
                );
                if (ptUserInfoDO != null) {
                    ptUserInfoDO.setUserId(createReqVO.getUserId());
                    ptUserInfoDO.setUserName(createReqVO.getUserName());
                    ptUserInfoDO.setUserRealName(createReqVO.getUserRealName());
                    ptUserInfoDO.setOrgId(createReqVO.getOrgId());
                    ptUserInfoDO.setOrgName(createReqVO.getOrgName());
                    ptUserInfoMapper.updateById(ptUserInfoDO);
                } else {
                    createPtUserInfo(createReqVO);
                }
            }
        }
        return "同步成功";
    }

}