package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.PtDeptInfoPageReqVO;
import cn.gintone.controller.vo.PtDeptInfoRespVO;
import cn.gintone.controller.vo.PtDeptInfoSaveReqVO;
import cn.gintone.dal.PtDeptInfoMapper;
import cn.gintone.dtoPt.PtData;
import cn.gintone.dtoPt.PtDeptInfo;
import cn.gintone.entity.PtDeptInfoDO;
import cn.gintone.myconf.BasicUrlConf;
import cn.gintone.utils.BasicInfoHttpUtils;
import cn.iocoder.yudao.module.system.controller.admin.auth.myVo.PtResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;


import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 平台部门 Service 实现类
 *
 * @author 安全系统管理
 */
@Service
@Validated
public class PtDeptInfoServiceImpl implements PtDeptInfoService {

    @Resource
    private BasicUrlConf basicUrlConf;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private PtDeptInfoMapper ptDeptInfoMapper;

    @Override
    public Long createPtDeptInfo(PtDeptInfoSaveReqVO createReqVO) {
        // 插入
        PtDeptInfoDO ptDeptInfo = BeanUtils.toBean(createReqVO, PtDeptInfoDO.class);
        ptDeptInfoMapper.insert(ptDeptInfo);
        // 返回
        return ptDeptInfo.getId();
    }

    @Override
    public void updatePtDeptInfo(PtDeptInfoSaveReqVO updateReqVO) {
        // 校验存在
        validatePtDeptInfoExists(updateReqVO.getId());
        // 更新
        PtDeptInfoDO updateObj = BeanUtils.toBean(updateReqVO, PtDeptInfoDO.class);
        ptDeptInfoMapper.updateById(updateObj);
    }

    @Override
    public void deletePtDeptInfo(Long id) {
        // 校验存在
        validatePtDeptInfoExists(id);
        // 删除
        ptDeptInfoMapper.deleteById(id);
    }

    private void validatePtDeptInfoExists(Long id) {
        if (ptDeptInfoMapper.selectById(id) == null) {
            throw exception(ErrorInfo.PT_DEPT_INFO_NOT_EXISTS);
        }
    }

    @Override
    public PtDeptInfoDO getPtDeptInfo(Long id) {
        return ptDeptInfoMapper.selectById(id);
    }

    @Override
    public PageResult<PtDeptInfoDO> getPtDeptInfoPage(PtDeptInfoPageReqVO pageReqVO) {
        return ptDeptInfoMapper.selectPage(pageReqVO);
    }

    @Override
    public String syncPtDept() {
        String pdToken = stringRedisTemplate.opsForValue().get("pdToken");
        PtResult<PtData<PtDeptInfo>> result = BasicInfoHttpUtils.getDeptInfo(basicUrlConf.getDeptInfoUrl(), "secure", pdToken);
        PtData<PtDeptInfo> data = result.getData();
        List<PtDeptInfo> rowData = data.getRowData();
        if (rowData != null && rowData.size() > 0) {
            for (PtDeptInfo deptInfo : rowData) {
                PtDeptInfoSaveReqVO createReqVO = new PtDeptInfoSaveReqVO();
                createReqVO.setOrgId(deptInfo.getORG_ID());


                PtDeptInfoDO ptDeptInfoDO = ptDeptInfoMapper.selectOne(new QueryWrapper<PtDeptInfoDO>()
                        .lambda()
                        .eq(PtDeptInfoDO::getOrgId, createReqVO.getOrgId())
                );
                if (ptDeptInfoDO != null) {
                    ptDeptInfoDO.setOrgCode(deptInfo.getORG_CODE());
                    ptDeptInfoDO.setOrgName(deptInfo.getORG_NAME());
                    ptDeptInfoDO.setOrgType(deptInfo.getORG_TYPE());
                    ptDeptInfoDO.setParentOrgId(deptInfo.getPARENT_ORG_ID());
                    ptDeptInfoDO.setParentOrgName(deptInfo.getPARENT_ORG_NAME());
                    ptDeptInfoMapper.updateById(ptDeptInfoDO);
                } else {
                    createReqVO.setOrgCode(deptInfo.getORG_CODE());
                    createReqVO.setOrgName(deptInfo.getORG_NAME());
                    createReqVO.setOrgType(deptInfo.getORG_TYPE());
                    createReqVO.setParentOrgId(deptInfo.getPARENT_ORG_ID());
                    createReqVO.setParentOrgName(deptInfo.getPARENT_ORG_NAME());
                    createPtDeptInfo(createReqVO);
                }


            }
        }
        return "同步成功";
    }

}