package cn.gintone.service;

import java.util.*;
import javax.validation.*;

import cn.gintone.controller.vo.PtDeptInfoPageReqVO;
import cn.gintone.controller.vo.PtDeptInfoRespVO;
import cn.gintone.controller.vo.PtDeptInfoSaveReqVO;
import cn.gintone.entity.PtDeptInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;

/**
 * 平台部门 Service 接口
 *
 * @author 安全系统管理
 */
public interface PtDeptInfoService {

    /**
     * 创建平台部门
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createPtDeptInfo(@Valid PtDeptInfoSaveReqVO createReqVO);

    /**
     * 更新平台部门
     *
     * @param updateReqVO 更新信息
     */
    void updatePtDeptInfo(@Valid PtDeptInfoSaveReqVO updateReqVO);

    /**
     * 删除平台部门
     *
     * @param id 编号
     */
    void deletePtDeptInfo(Long id);

    /**
     * 获得平台部门
     *
     * @param id 编号
     * @return 平台部门
     */
    PtDeptInfoDO getPtDeptInfo(Long id);

    /**
     * 获得平台部门分页
     *
     * @param pageReqVO 分页查询
     * @return 平台部门分页
     */
    PageResult<PtDeptInfoDO> getPtDeptInfoPage(PtDeptInfoPageReqVO pageReqVO);

    /**
     * 同步平台数据
     * @return
     */
    String syncPtDept();
}