package cn.gintone.service;

import cn.gintone.controller.vo.DeviceConnetRulePageReqVO;
import cn.gintone.controller.vo.DeviceConnetRuleSaveReqVO;
import cn.gintone.entity.DeviceConnetRuleDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;

/**
 * 设备连接规则 Service 接口
 *
 * @author 胡懿
 */
public interface DeviceConnetRuleService {

    /**
     * 创建设备连接规则
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createConnetRule(@Valid DeviceConnetRuleSaveReqVO createReqVO);

    /**
     * 更新设备连接规则
     *
     * @param updateReqVO 更新信息
     */
    void updateConnetRule(@Valid DeviceConnetRuleSaveReqVO updateReqVO);

    /**
     * 删除设备连接规则
     *
     * @param id 编号
     */
    void deleteConnetRule(Long id);

    /**
     * 获得设备连接规则
     *
     * @param id 编号
     * @return 设备连接规则
     */
    DeviceConnetRuleDO getConnetRule(Long id);

    /**
     * 获得设备连接规则分页
     *
     * @param pageReqVO 分页查询
     * @return 设备连接规则分页
     */
    PageResult<DeviceConnetRuleDO> getConnetRulePage(DeviceConnetRulePageReqVO pageReqVO);

}