package cn.gintone.entity;

import lombok.*;
import java.util.*;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * web请求配置 DO
 *
 * @author 安全系统管理
 */
@TableName("t_web_req_conf")
@KeySequence("t_web_req_conf_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WebReqConfDO extends BaseDO {

    public static final Long PARENT_ID_ROOT = 0L;

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 系统简称中文
     */
    private String abbreCn;
    /**
     * 系统简称外键
     */
    private Long abbreId;
    /**
     * api地址
     */
    private String apiUrl;
    /**
     * api名称
     */
    private String apiName;
    /**
     * 父级id
     */
    private Long parentId;
    /**
     * 方位地址id
     */
    private String apiId;
    /**
     * 访问地址父级id
     */
    private String apiParentId;

}