package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 物联网设备请求配置 DO
 *
 * @author 安全系统管理
 */
@TableName("t_device_req_conf")
@KeySequence("t_device_req_conf_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeviceReqConfDO extends BaseDO {

    public static final Long PARENT_ID_ROOT = 0L;

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 设备名称
     */
    private String deviceName;
    /**
     * 设备id
     */
    private String deviceId;
    /**
     * 设备类型id
     */
    private Long deviceTypeId;

    private String deviceTypeName;
    /**
     * 父级id
     */
    private Long parentId;

    private String snCode; // sn
    private String address; // 地址
    private String deviceEn; // 设备英文
    private String regionName; // Device Sec
    private Integer state; // 设备状态
    private Date sycnDate; // 设备状态监测时间
}