package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.WebReqConfListReqVO;
import cn.gintone.entity.WebReqConfDO;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * web请求配置 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface WebReqConfMapper extends BaseMapperX<WebReqConfDO> {

    default List<WebReqConfDO> selectList(WebReqConfListReqVO reqVO) {
        return selectList(new LambdaQueryWrapperX<WebReqConfDO>()
                .eqIfPresent(WebReqConfDO::getAbbreCn, reqVO.getAbbreCn())
                .eqIfPresent(WebReqConfDO::getAbbreId, reqVO.getAbbreId())
                .eqIfPresent(WebReqConfDO::getApiUrl, reqVO.getApiUrl())
                .likeIfPresent(WebReqConfDO::getApiName, reqVO.getApiName())
                .betweenIfPresent(WebReqConfDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(WebReqConfDO::getParentId, reqVO.getParentId())
                .orderByDesc(WebReqConfDO::getId));
    }

	default WebReqConfDO selectByParentIdAndApiName(Long parentId, String apiName) {
	    return selectOne(WebReqConfDO::getParentId, parentId, WebReqConfDO::getApiName, apiName);
	}

    default Long selectCountByParentId(Long parentId) {
        return selectCount(WebReqConfDO::getParentId, parentId);
    }

}