package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.DeviceReqConfListReqVO;
import cn.gintone.entity.DeviceReqConfDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 物联网设备请求配置 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface DeviceReqConfMapper extends BaseMapperX<DeviceReqConfDO> {

    default List<DeviceReqConfDO> selectList(DeviceReqConfListReqVO reqVO) {
        return selectList(new LambdaQueryWrapperX<DeviceReqConfDO>()
                .likeIfPresent(DeviceReqConfDO::getDeviceName, reqVO.getDeviceName())
                .eqIfPresent(DeviceReqConfDO::getDeviceId, reqVO.getDeviceId())
                .eqIfPresent(DeviceReqConfDO::getDeviceTypeId, reqVO.getDeviceTypeId())
                .eqIfPresent(DeviceReqConfDO::getParentId, reqVO.getParentId())
                .betweenIfPresent(DeviceReqConfDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeviceReqConfDO::getId));
    }

	default DeviceReqConfDO selectByParentIdAndDeviceName(Long parentId, String deviceName) {
	    return selectOne(DeviceReqConfDO::getParentId, parentId, DeviceReqConfDO::getDeviceName, deviceName);
	}

    default Long selectCountByParentId(Long parentId) {
        return selectCount(DeviceReqConfDO::getParentId, parentId);
    }

}