package cn.gintone.dal;

import cn.gintone.controller.vo.DeviceConnetRuleInfoPageReqVO;
import cn.gintone.entity.DeviceConnetRuleInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 设备规则配置细则 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface DeviceConnetRuleInfoMapper extends BaseMapperX<DeviceConnetRuleInfoDO> {

    default PageResult<DeviceConnetRuleInfoDO> selectPage(DeviceConnetRuleInfoPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<DeviceConnetRuleInfoDO>()
                .eqIfPresent(DeviceConnetRuleInfoDO::getDeviceRuleId, reqVO.getDeviceRuleId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getDeviceName, reqVO.getDeviceName())
                .eqIfPresent(DeviceConnetRuleInfoDO::getDeviceId, reqVO.getDeviceId())
                .eqIfPresent(DeviceConnetRuleInfoDO::getRoleId, reqVO.getRoleId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getRoleName, reqVO.getRoleName())
                .eqIfPresent(DeviceConnetRuleInfoDO::getUserId, reqVO.getUserId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getUserName, reqVO.getUserName())
                .betweenIfPresent(DeviceConnetRuleInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeviceConnetRuleInfoDO::getId));
    }

    default List<DeviceConnetRuleInfoDO> selectList(DeviceConnetRuleInfoPageReqVO reqVO) {
        List<DeviceConnetRuleInfoDO> deviceConnetRuleInfoDOS = selectList(new LambdaQueryWrapperX<DeviceConnetRuleInfoDO>()
                .eqIfPresent(DeviceConnetRuleInfoDO::getDeviceRuleId, reqVO.getDeviceRuleId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getDeviceName, reqVO.getDeviceName())
                .eqIfPresent(DeviceConnetRuleInfoDO::getDeviceId, reqVO.getDeviceId())
                .eqIfPresent(DeviceConnetRuleInfoDO::getRoleId, reqVO.getRoleId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getRoleName, reqVO.getRoleName())
                .eqIfPresent(DeviceConnetRuleInfoDO::getUserId, reqVO.getUserId())
                .likeIfPresent(DeviceConnetRuleInfoDO::getUserName, reqVO.getUserName())
                .betweenIfPresent(DeviceConnetRuleInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeviceConnetRuleInfoDO::getId));
        return deviceConnetRuleInfoDOS;
    }

}