package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - web请求配置 Response VO")
@Data
@ExcelIgnoreUnannotated
public class WebReqConfRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30098")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "系统简称中文")
    @ExcelProperty("系统简称中文")
    private String abbreCn;

    @Schema(description = "系统简称外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "19731")
    @ExcelProperty("系统简称外键")
    private Long abbreId;

    @Schema(description = "api地址", example = "https://www.iocoder.cn")
    @ExcelProperty("api地址")
    private String apiUrl;

    @Schema(description = "api名称", example = "李四")
    @ExcelProperty("api名称")
    private String apiName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "父级id", example = "28717")
    @ExcelProperty("父级id")
    private Long parentId;

    /**
     * 方位地址id
     */
    @Schema(description = "api父级id", example = "28718")
    @ExcelProperty("api父级id")
    private String apiId;
    /**
     * 访问地址父级id
     */
    @Schema(description = "访问地址父级id", example = "28719")
    @ExcelProperty("api父级id")
    private String apiParentId;
}