package cn.gintone.controller.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - web请求配置列表 Request VO")
@Data
public class WebReqConfListReqVO {

    @Schema(description = "系统简称中文")
    private String abbreCn;

    @Schema(description = "系统简称外键", example = "19731")
    private Long abbreId;

    @Schema(description = "api地址", example = "https://www.iocoder.cn")
    private String apiUrl;

    @Schema(description = "api名称", example = "李四")
    private String apiName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "父级id", example = "28717")
    private Long parentId;

    /**
     * 方位地址id
     */
    @Schema(description = "api父级id", example = "28718")
    private String apiId;
    /**
     * 访问地址父级id
     */
    @Schema(description = "访问地址父级id", example = "28719")
    private String apiParentId;
}