package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 访问规则配置 Response VO")
@Data
@ExcelIgnoreUnannotated
public class VisitInfoRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31715")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "规则表外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "10305")
    @ExcelProperty("规则表外键")
    private Long visitId;

    @Schema(description = "系统简称", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("系统简称")
    private String sysAbbre;

    @Schema(description = "系统名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "王五")
    @ExcelProperty("系统名称")
    private String sysAbbreName;

    @Schema(description = "菜单名称", example = "王五")
    @ExcelProperty("菜单名称")
    private String urlName;

    @Schema(description = "菜单地址", example = "https://www.iocoder.cn")
    @ExcelProperty("菜单地址")
    private String url;
    @Schema(description = "菜单地址Id", example = "https://www.iocoder.cn")
    @ExcelProperty("菜单地址Id")
    private String urlId;

    @Schema(description = "角色id", example = "6818")
    @ExcelProperty("角色id")
    private String roleId;

    @Schema(description = "角色名称", example = "李四")
    @ExcelProperty("角色名称")
    private String roleName;

    @Schema(description = "用户id", example = "31619")
    @ExcelProperty("用户id")
    private String userId;

    @Schema(description = "用户名称", example = "王五")
    @ExcelProperty("用户名称")
    private String userName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}