package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 平台用户 Response VO")
@Data
@ExcelIgnoreUnannotated
public class PtUserInfoRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "49")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "用户id", example = "28834")
    @ExcelProperty("用户id")
    private Long userId;

    @Schema(description = "用户民", example = "李四")
    @ExcelProperty("用户民")
    private String userName;

    @Schema(description = "用户真实姓名", example = "张三")
    @ExcelProperty("用户真实姓名")
    private String userRealName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    private String orgId;
    private String orgName;
}