package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 平台部门新增/修改 Request VO")
@Data
public class PtDeptInfoSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "11535")
    private Long id;

    @Schema(description = "部门id", example = "16712")
    private String orgId;

    @Schema(description = "部门编码")
    private String orgCode;

    @Schema(description = "部门名称", example = "芋艿")
    private String orgName;

    @Schema(description = "部门类型", example = "2")
    private String orgType;

    @Schema(description = "父部门id", example = "16885")
    private String parentOrgId;

    @Schema(description = "父部门名称", example = "芋艿")
    private String parentOrgName;

}