package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 平台部门 Response VO")
@Data
@ExcelIgnoreUnannotated
public class PtDeptInfoRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "11535")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "部门id", example = "16712")
    @ExcelProperty("部门id")
    private String orgId;

    @Schema(description = "部门编码")
    @ExcelProperty("部门编码")
    private String orgCode;

    @Schema(description = "部门名称", example = "芋艿")
    @ExcelProperty("部门名称")
    private String orgName;

    @Schema(description = "部门类型", example = "2")
    @ExcelProperty("部门类型")
    private String orgType;

    @Schema(description = "父部门id", example = "16885")
    @ExcelProperty("父部门id")
    private String parentOrgId;

    @Schema(description = "父部门名称", example = "芋艿")
    @ExcelProperty("父部门名称")
    private String parentOrgName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}