package cn.gintone.controller.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 平台部门分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PtDeptInfoPageReqVO extends PageParam {

    @Schema(description = "部门id", example = "16712")
    private String orgId;

    @Schema(description = "部门编码")
    private String orgCode;

    @Schema(description = "部门名称", example = "芋艿")
    private String orgName;

    @Schema(description = "部门类型", example = "2")
    private String orgType;

    @Schema(description = "父部门id", example = "16885")
    private String parentOrgId;

    @Schema(description = "父部门名称", example = "芋艿")
    private String parentOrgName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}