package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 公钥私钥管理新增/修改 Request VO")
@Data
public class KeyCodeSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4344")
    private Long id;

    @Schema(description = "类型用户编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    @NotNull(message = "类型用户编号不能为空")
    private Integer type;

    @Schema(description = "公钥用户类型", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "公钥用户类型不能为空")
    private String publicKey;

    @Schema(description = "私钥", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "私钥不能为空")
    private String privateKey;

}