package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 重要文件 Response VO")
@Data
@ExcelIgnoreUnannotated
public class ImportantFileRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "10127")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "文件名", example = "张三")
    @ExcelProperty("文件名")
    private String name;

    @Schema(description = "文件地址", example = "https://www.iocoder.cn")
    @ExcelProperty("文件地址")
    private String url;

    @Schema(description = "私钥")
    @ExcelProperty("私钥")
    private String privateKey;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}