package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 设备类型 Response VO")
@Data
@ExcelIgnoreUnannotated
public class DeviceTypeRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3316")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "设备类型名称", example = "赵六")
    @ExcelProperty("设备类型名称")
    private String name;

    @Schema(description = "设备类型标识")
    @ExcelProperty("设备类型标识")
    private String modelCode;

    @Schema(description = "厂家设备类型标识")
    @ExcelProperty("厂家设备类型标识")
    private String manufacturer;

    @Schema(description = "所属集成应用")
    @ExcelProperty("所属集成应用")
    private String integratedApplicationOwnership;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}