package cn.gintone.controller;

import cn.gintone.dal.SysAbbreMapper;
import cn.gintone.dtoPt.PtData;
import cn.gintone.dtoPt.PtMenuInfo;
import cn.gintone.entity.SysAbbreDO;
import cn.gintone.entity.WebReqConfDO;
import cn.gintone.myconf.BasicUrlConf;
import cn.gintone.utils.BasicInfoHttpUtils;
import cn.iocoder.yudao.module.system.controller.admin.auth.myVo.PtResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.*;
import javax.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;

import cn.gintone.controller.vo.*;
import cn.gintone.service.WebReqConfService;

@Tag(name = "管理后台 - web请求配置")
@RestController
@RequestMapping("/admin-api/sec/web-req-conf")
@Validated
public class WebReqConfController {

    @Resource
    private WebReqConfService webReqConfService;

    @Resource
    private BasicUrlConf basicUrlConf;
    @Autowired
    private SysAbbreMapper sysAbbreMapper;

    @PostMapping("/create")
    @Operation(summary = "创建web请求配置")
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:create')")
    public CommonResult<Long> createWebReqConf(@Valid @RequestBody WebReqConfSaveReqVO createReqVO) {
        return success(webReqConfService.createWebReqConf(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新web请求配置")
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:update')")
    public CommonResult<Boolean> updateWebReqConf(@Valid @RequestBody WebReqConfSaveReqVO updateReqVO) {
        webReqConfService.updateWebReqConf(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除web请求配置")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:delete')")
    public CommonResult<Boolean> deleteWebReqConf(@RequestParam("id") Long id) {
        webReqConfService.deleteWebReqConf(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得web请求配置")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:query')")
    public CommonResult<WebReqConfRespVO> getWebReqConf(@RequestParam("id") Long id) {
        WebReqConfDO webReqConf = webReqConfService.getWebReqConf(id);
        return success(BeanUtils.toBean(webReqConf, WebReqConfRespVO.class));
    }

    @GetMapping("/list")
    @Operation(summary = "获得web请求配置列表")
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:query')")
    public CommonResult<List<WebReqConfRespVO>> getWebReqConfList(@Valid WebReqConfListReqVO listReqVO) {
        List<WebReqConfDO> list = webReqConfService.getWebReqConfList(listReqVO);
        return success(BeanUtils.toBean(list, WebReqConfRespVO.class));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出web请求配置 Excel")
    @PreAuthorize("@ss.hasPermission('sec:web-req-conf:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportWebReqConfExcel(@Valid WebReqConfListReqVO listReqVO,
              HttpServletResponse response) throws IOException {
        List<WebReqConfDO> list = webReqConfService.getWebReqConfList(listReqVO);
        // 导出 Excel
        ExcelUtils.write(response, "web请求配置.xls", "数据", WebReqConfRespVO.class,
                        BeanUtils.toBean(list, WebReqConfRespVO.class));
    }


    /*
    同步平台api数据
     */
    @GetMapping("/synchronizeApi")
    public CommonResult<String> synchronizeApi() {
        SysAbbreDO secure = sysAbbreMapper.selectOne(new QueryWrapper<SysAbbreDO>()
                .lambda()
                .eq(SysAbbreDO::getAbbreEn, "SLPT")
        );
        PtResult<PtData<PtMenuInfo>> ptMenuList = BasicInfoHttpUtils.getPtMenu(basicUrlConf.getMenuInfoUrl(), "", "");
        PtData<PtMenuInfo> data = ptMenuList.getData();
        if (data != null) {
            List<PtMenuInfo> rowDataList = data.getRowData();
            if (rowDataList != null && rowDataList.size() > 0) {
                for (PtMenuInfo rowData : rowDataList) {
                    String pValue = rowData.getP_VALUE();
                    if (pValue != null && pValue.length() > 1) {
                        WebReqConfSaveReqVO webReqConfSaveReqVO = new WebReqConfSaveReqVO();
                        webReqConfSaveReqVO.setApiUrl(pValue);
                        webReqConfSaveReqVO.setApiId(rowData.getP_ID() + "");
                        if (null != rowData.getPARENT_P_ID()) {
                            webReqConfSaveReqVO.setApiParentId(rowData.getPARENT_P_ID() + "");
                        }
                        webReqConfSaveReqVO.setApiName(rowData.getP_NAME());
                        webReqConfSaveReqVO.setAbbreId(secure.getId());
                        webReqConfSaveReqVO.setAbbreCn(secure.getAbbreCn());
                        webReqConfService.myCreateWebReqConf(webReqConfSaveReqVO);
                    }
                }
            }
        }
        return success("同步成功");
    }



}