package cn.gintone.controller;

import cn.gintone.controller.vo.SysAbbrePageReqVO;
import cn.gintone.controller.vo.SysAbbreRespVO;
import cn.gintone.controller.vo.SysAbbreSaveReqVO;
import cn.gintone.entity.SysAbbreDO;
import cn.gintone.service.SysAbbreService;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.List;

import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;

@Tag(name = "管理后台 - 系统简称")
@RestController
@RequestMapping("/admin-api/gintone/sys-abbre")
@Validated
public class SysAbbreController {

    @Resource
    private SysAbbreService sysAbbreService;

    @PostMapping("/create")
    @Operation(summary = "创建系统简称")
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:create')")
    public CommonResult<Long> createSysAbbre(@Valid @RequestBody SysAbbreSaveReqVO createReqVO) {
        return success(sysAbbreService.createSysAbbre(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新系统简称")
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:update')")
    public CommonResult<Boolean> updateSysAbbre(@Valid @RequestBody SysAbbreSaveReqVO updateReqVO) {
        sysAbbreService.updateSysAbbre(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除系统简称")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:delete')")
    public CommonResult<Boolean> deleteSysAbbre(@RequestParam("id") Long id) {
        sysAbbreService.deleteSysAbbre(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得系统简称")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:query')")
    public CommonResult<SysAbbreRespVO> getSysAbbre(@RequestParam("id") Long id) {
        SysAbbreDO sysAbbre = sysAbbreService.getSysAbbre(id);
        return success(BeanUtils.toBean(sysAbbre, SysAbbreRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得系统简称分页")
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:query')")
    public CommonResult<PageResult<SysAbbreRespVO>> getSysAbbrePage(@Valid SysAbbrePageReqVO pageReqVO) {
        PageResult<SysAbbreDO> pageResult = sysAbbreService.getSysAbbrePage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, SysAbbreRespVO.class));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出系统简称 Excel")
    @PreAuthorize("@ss.hasPermission('gintone:sys-abbre:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportSysAbbreExcel(@Valid SysAbbrePageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<SysAbbreDO> list = sysAbbreService.getSysAbbrePage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "系统简称.xls", "数据", SysAbbreRespVO.class,
                        BeanUtils.toBean(list, SysAbbreRespVO.class));
    }

}