package cn.gintone.controller;

import cn.gintone.controller.vo.PtDeptInfoPageReqVO;
import cn.gintone.controller.vo.PtDeptInfoRespVO;
import cn.gintone.controller.vo.PtDeptInfoSaveReqVO;
import cn.gintone.entity.PtDeptInfoDO;
import cn.gintone.service.PtDeptInfoService;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.constraints.*;
import javax.validation.*;
import javax.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;


@Tag(name = "管理后台 - 平台部门")
@RestController
@RequestMapping("/admin-api/ptinfo/pt-dept-info")
@Validated
public class PtDeptInfoController {

    @Resource
    private PtDeptInfoService ptDeptInfoService;

    @PostMapping("/create")
    @Operation(summary = "创建平台部门")
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:create')")
    public CommonResult<Long> createPtDeptInfo(@Valid @RequestBody PtDeptInfoSaveReqVO createReqVO) {
        return success(ptDeptInfoService.createPtDeptInfo(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新平台部门")
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:update')")
    public CommonResult<Boolean> updatePtDeptInfo(@Valid @RequestBody PtDeptInfoSaveReqVO updateReqVO) {
        ptDeptInfoService.updatePtDeptInfo(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除平台部门")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:delete')")
    public CommonResult<Boolean> deletePtDeptInfo(@RequestParam("id") Long id) {
        ptDeptInfoService.deletePtDeptInfo(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得平台部门")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:query')")
    public CommonResult<PtDeptInfoRespVO> getPtDeptInfo(@RequestParam("id") Long id) {
        PtDeptInfoDO ptDeptInfo = ptDeptInfoService.getPtDeptInfo(id);
        return success(BeanUtils.toBean(ptDeptInfo, PtDeptInfoRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得平台部门分页")
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:query')")
    public CommonResult<PageResult<PtDeptInfoRespVO>> getPtDeptInfoPage(@Valid PtDeptInfoPageReqVO pageReqVO) {
        PageResult<PtDeptInfoDO> pageResult = ptDeptInfoService.getPtDeptInfoPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, PtDeptInfoRespVO.class));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出平台部门 Excel")
    @PreAuthorize("@ss.hasPermission('ptinfo:pt-dept-info:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportPtDeptInfoExcel(@Valid PtDeptInfoPageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<PtDeptInfoDO> list = ptDeptInfoService.getPtDeptInfoPage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "平台部门.xls", "数据", PtDeptInfoRespVO.class,
                        BeanUtils.toBean(list, PtDeptInfoRespVO.class));
    }

    @GetMapping("/syncPtDept")
    @Operation(summary = "同步平台部门信息")
    public CommonResult<String> syncPtDept() {
        return success(ptDeptInfoService.syncPtDept());
    }

}