package cn.gintone.config;


import cn.gintone.dto.DeviceLogInfo;
import cn.gintone.dto.WebLogInfo;
import cn.gintone.iotdbUtils.MyIotDbUtils;
import cn.gintone.service.DeviceConnetRuleInfoService;
import cn.gintone.service.VisitInfoService;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumer {

    @Autowired
    private IotDbConfig iotDbConfig;

    @Autowired
    private VisitInfoService visitInfoService;
    @Autowired
    private DeviceConnetRuleInfoService deviceConnetRuleInfoService;

    @KafkaListener(
            topics = "weblog.save",
            containerFactory = "kafkaListenerContainerFactory1",
            groupId = "weblog_consumer_group"
    )
    public void consume(String message){
        WebLogInfo webLogInfo = JSON.parseObject(JSON.parse(message).toString(), WebLogInfo.class);
        if (webLogInfo.getReqType().contains("req")) {
            MyIotDbUtils.inserOne(iotDbConfig, webLogInfo);
            visitInfoService.checkWebLogInfo(webLogInfo);
        } else {
            DeviceLogInfo deviceLogInfo = new DeviceLogInfo();
            deviceLogInfo.setUserId(webLogInfo.getUserId());
            deviceLogInfo.setUsername(webLogInfo.getUsername());
            deviceLogInfo.setDeviceTypeBs(webLogInfo.getDeviceTypeBs());
            deviceLogInfo.setDeviceName(webLogInfo.getDeviceTypeName());
            deviceLogInfo.setAccessed(webLogInfo.getAccessed());
            deviceLogInfo.setType(webLogInfo.getType());
            deviceLogInfo.setClientIp(webLogInfo.getClientIp());
            deviceLogInfo.setRemark(webLogInfo.getRemark());
            MyIotDbUtils.inserOneDeviceLogInfo(iotDbConfig, deviceLogInfo);
            deviceConnetRuleInfoService.checkDeviceLogInfo(deviceLogInfo);
        }
        /*if (webLogInfo.getReqType().contains("dev")) {
            DeviceLogInfo deviceLogInfo = JSON.parseObject(JSON.parse(jsonStr).toString(), DeviceLogInfo.class);
            MyIotDbUtils.inserOneDeviceLogInfo(iotDbConfig, deviceLogInfo);
            deviceConnetRuleInfoService.checkDeviceLogInfo(deviceLogInfo);
        }*/
    }


    @KafkaListener(
            topics = "devicelog.save",
            containerFactory = "kafkaListenerContainerFactory1",
            groupId = "weblog_consumer_group"
    )
    public void consume2(String message){
        DeviceLogInfo deviceLogInfo = JSON.parseObject(JSON.parse(message).toString(), DeviceLogInfo.class);
        MyIotDbUtils.inserOneDeviceLogInfo(iotDbConfig, deviceLogInfo);
        deviceConnetRuleInfoService.checkDeviceLogInfo(deviceLogInfo);
    }
}
