package cn.gintone.service;

import cn.gintone.controller.vo.DesCorporationPageReqVO;
import cn.gintone.controller.vo.DesCorporationSaveReqVO;
import cn.gintone.entity.DesCorporationDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;
import java.util.List;
import java.util.Map;

/**
 * 法人脱敏 Service 接口
 *
 * @author 胡懿
 */
public interface DesCorporationService {

    /**
     * 创建法人脱敏
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createDesCorporation(@Valid DesCorporationSaveReqVO createReqVO);

    /**
     * 更新法人脱敏
     *
     * @param updateReqVO 更新信息
     */
    void updateDesCorporation(@Valid DesCorporationSaveReqVO updateReqVO);

    /**
     * 删除法人脱敏
     *
     * @param id 编号
     */
    void deleteDesCorporation(Long id);

    /**
     * 获得法人脱敏
     *
     * @param id 编号
     * @return 法人脱敏
     */
    DesCorporationDO getDesCorporation(Long id);

    /**
     * 获得法人脱敏分页
     *
     * @param pageReqVO 分页查询
     * @return 法人脱敏分页
     */
    PageResult<DesCorporationDO> getDesCorporationPage(DesCorporationPageReqVO pageReqVO);

    Boolean checkName(String name, Long id);

    String corporationRuleDes(String jsonStr);

    String corporationRuleDesArr(String jsonArrStr);

    Map<String, Object> corporationRuleDesMap(Map<String, Object> map);

    List<Map<String, Object>> corporationRuleDesListMap(List<Map<String, Object>> lisetMap);
}