package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.SysAbbrePageReqVO;
import cn.gintone.entity.SysAbbreDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 系统简称 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface SysAbbreMapper extends BaseMapperX<SysAbbreDO> {

    default PageResult<SysAbbreDO> selectPage(SysAbbrePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<SysAbbreDO>()
                .eqIfPresent(SysAbbreDO::getAbbreCn, reqVO.getAbbreCn())
                .eqIfPresent(SysAbbreDO::getAbbreEn, reqVO.getAbbreEn())
                .betweenIfPresent(SysAbbreDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(SysAbbreDO::getId));
    }

}