package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.PtUserInfoPageReqVO;
import cn.gintone.entity.PtUserInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 平台用户 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface PtUserInfoMapper extends BaseMapperX<PtUserInfoDO> {

    default PageResult<PtUserInfoDO> selectPage(PtUserInfoPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<PtUserInfoDO>()
                .eqIfPresent(PtUserInfoDO::getUserId, reqVO.getUserId())
                .likeIfPresent(PtUserInfoDO::getUserName, reqVO.getUserName())
                .likeIfPresent(PtUserInfoDO::getUserRealName, reqVO.getUserRealName())
                .eqIfPresent(PtUserInfoDO::getOrgId, reqVO.getOrgId())
                .eqIfPresent(PtUserInfoDO::getOrgName, reqVO.getOrgName())
                .betweenIfPresent(PtUserInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(PtUserInfoDO::getId));
    }

}