package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.DeviceTypePageReqVO;
import cn.gintone.entity.DeviceTypeDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 设备类型 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface DeviceTypeMapper extends BaseMapperX<DeviceTypeDO> {

    default PageResult<DeviceTypeDO> selectPage(DeviceTypePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<DeviceTypeDO>()
                .likeIfPresent(DeviceTypeDO::getName, reqVO.getName())
                .eqIfPresent(DeviceTypeDO::getModelCode, reqVO.getModelCode())
                .eqIfPresent(DeviceTypeDO::getManufacturer, reqVO.getManufacturer())
                .eqIfPresent(DeviceTypeDO::getIntegratedApplicationOwnership, reqVO.getIntegratedApplicationOwnership())
                .betweenIfPresent(DeviceTypeDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeviceTypeDO::getId));
    }

}