package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 物联网设备请求配置新增/修改 Request VO")
@Data
public class DeviceReqConfSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "9080")
    private Long id;

    @Schema(description = "设备名称", example = "张三")
    private String deviceName;

    @Schema(description = "设备id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21048")
    @NotEmpty(message = "设备id不能为空")
    private String deviceId;

    @Schema(description = "设备类型id", example = "24373")
    private Long deviceTypeId;

    @Schema(description = "父级id", example = "31343")
    private Long parentId;

    private String snCode; // sn
    private String address; // 地址
    private String deviceEn; // 设备英文
    private String regionName; // 区域名称
    private String deviceTypeName;
    private Integer state; // 设备状态
    private Date sycnDate; // 设备状态监测时间
}