package cn.gintone.controller;

import cn.gintone.config.IotDbConfig;
import cn.gintone.dto.*;
import cn.gintone.iotdbUtils.MyDateUtils;
import cn.gintone.iotdbUtils.MyIotDbUtils;
import cn.iocoder.yudao.framework.common.exception.ErrorCode;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/admin-api/gintone/deviceLogInfo")
public class DeviceLogInfoController {
    @Autowired
    private IotDbConfig iotDbConfig;
    @Resource
    private KafkaTemplate<String,String> kafkaTemplate;

    @PermitAll
    @PostMapping("/saveDeviceLogInfo")
    @Operation(summary = "外部性请求保存日志")
    public CommonResult<String> saveDeviceLogInfo(@RequestBody DeviceLogInfo deviceLogInfo) {
        if (null == deviceLogInfo.getAccessed()) {
            deviceLogInfo.setAccessed(MyDateUtils.longToString(new Date().getTime()));
        }
        String deviceLogInfoStr = JSON.toJSONString(deviceLogInfo);
//        rabbitTemplate.convertAndSend("my_boot_topic_exchange", "devicelog.save", deviceLogInfoStr);
        kafkaTemplate.send("devicelog.save",deviceLogInfoStr);
        return CommonResult.success("保存成功");
    }

    @PermitAll
    @PostMapping("/saveDeviceLogInfoList")
    @Operation(summary = "外部性请求保存日志")
    public CommonResult<String> saveDeviceLogInfoList(@RequestBody List<DeviceLogInfo> deviceLogInfoList) {
        if (null != deviceLogInfoList && deviceLogInfoList.size() > 0) {
            for (DeviceLogInfo deviceLogInfo : deviceLogInfoList) {
                if (null == deviceLogInfo.getAccessed()) {
                    deviceLogInfo.setAccessed(MyDateUtils.longToString(new Date().getTime()));
                }
                String deviceLogInfoStr = JSON.toJSONString(deviceLogInfo);
                kafkaTemplate.send("devicelog.save",deviceLogInfoStr);
            }

            return CommonResult.success("保存成功");
        } else {
            return CommonResult.error(new ErrorCode(205, "上报设备日志不能为空"));
        }


    }


    @GetMapping("/countDeviceIllLogInfo")
    @Operation(summary = "统计非法日志条数接口")
    public CommonResult<Long> countDeviceIllLogInfo(DeviceIllLogInfo deviceIllLogInfo) {
        long pageCount = MyIotDbUtils.countDeviceLogInfo_ill(iotDbConfig, deviceIllLogInfo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/deviceIllLogInfoList")
    @Operation(summary = "查询非法日志记录")
    public CommonResult<List<DeviceIllLogInfo>> deviceIllLogInfoList(DeviceIllLogInfo deviceIllLogInfo) {
        List<DeviceIllLogInfo> deviceIllLogInfoList = MyIotDbUtils.selectDeviceLogInfo_ill(iotDbConfig, deviceIllLogInfo);
        return CommonResult.success(deviceIllLogInfoList);
    }

    @GetMapping("/countDeviceLogInfo")
    @Operation(summary = "统计设备访问日志条数接口")
    public CommonResult<Long> countDeviceLogInfo(DeviceLogInfo deviceLogInfo) {
        long pageCount = MyIotDbUtils.countDeviceLogInfo(iotDbConfig, deviceLogInfo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/deviceLogInfoList")
    @Operation(summary = "查询设备访问日志记录")
    public CommonResult<List<DeviceLogInfo>> deviceLogInfoList(DeviceLogInfo deviceLogInfo) {
        List<DeviceLogInfo> deviceLogInfoList = MyIotDbUtils.selectDeviceLogInfo(iotDbConfig, deviceLogInfo);
        return CommonResult.success(deviceLogInfoList);
    }
}
