package cn.gintone.controller;

import cn.gintone.controller.vo.*;
import cn.gintone.dto.DeviceType;
import cn.gintone.entity.DeviceConnetRuleInfoDO;
import cn.gintone.entity.VisitInfoDO;
import cn.gintone.service.DeviceConnetRuleInfoService;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.List;

import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;

@Tag(name = "管理后台 - 设备规则配置细则")
@RestController
@RequestMapping("/admin-api/device/connet-rule-info")
@Validated
public class DeviceConnetRuleInfoController {

    @Resource
    private DeviceConnetRuleInfoService connetRuleInfoService;

    @PostMapping("/create")
    @Operation(summary = "创建设备规则配置细则")
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:create')")
    public CommonResult<Long> createConnetRuleInfo(@Valid @RequestBody DeviceConnetRuleInfoSaveReqVO createReqVO) {
        return success(connetRuleInfoService.createConnetRuleInfo(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新设备规则配置细则")
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:update')")
    public CommonResult<Boolean> updateConnetRuleInfo(@Valid @RequestBody DeviceConnetRuleInfoSaveReqVO updateReqVO) {
        connetRuleInfoService.updateConnetRuleInfo(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除设备规则配置细则")
    @Parameter(name = "id", description = "编号", required = true)
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:delete')")
    public CommonResult<Boolean> deleteConnetRuleInfo(@RequestParam("id") Long id) {
        connetRuleInfoService.deleteConnetRuleInfo(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得设备规则配置细则")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:query')")
    public CommonResult<DeviceConnetRuleInfoRespVO> getConnetRuleInfo(@RequestParam("id") Long id) {
        DeviceConnetRuleInfoDO connetRuleInfo = connetRuleInfoService.getConnetRuleInfo(id);
        return success(BeanUtils.toBean(connetRuleInfo, DeviceConnetRuleInfoRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得设备规则配置细则分页")
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:query')")
    public CommonResult<PageResult<DeviceConnetRuleInfoRespVO>> getConnetRuleInfoPage(@Valid DeviceConnetRuleInfoPageReqVO pageReqVO) {
        PageResult<DeviceConnetRuleInfoDO> pageResult = connetRuleInfoService.getConnetRuleInfoPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, DeviceConnetRuleInfoRespVO.class));
    }

    @GetMapping("/getList")
    @Operation(summary = "获得访问规则配置")
    public CommonResult<List<DeviceConnetRuleInfoDO>> getList(DeviceConnetRuleInfoPageReqVO pageReqVO) {
        List<DeviceConnetRuleInfoDO> list = connetRuleInfoService.getList(pageReqVO);
        return success(list);
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出设备规则配置细则 Excel")
//    @PreAuthorize("@ss.hasPermission('device:connet-rule-info:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportConnetRuleInfoExcel(@Valid DeviceConnetRuleInfoPageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<DeviceConnetRuleInfoDO> list = connetRuleInfoService.getConnetRuleInfoPage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "设备规则配置细则.xls", "数据", DeviceConnetRuleInfoRespVO.class,
                        BeanUtils.toBean(list, DeviceConnetRuleInfoRespVO.class));
    }

    @GetMapping("/getDeviceType")
    @Operation(summary = "获取设备信息")
    public CommonResult<List<DeviceType>> getDeviceType() {
        List<DeviceType> deviceTypeList = connetRuleInfoService.getDeviceType();
        return success(deviceTypeList);
    }


    @PostMapping("/saveAll")
    @Operation(summary = "创建设备访问细则")
    public CommonResult<Boolean> saveAll(@Valid @RequestBody List<DeviceConnetRuleInfoRespVO> deviceConnetRuleInfoRespVOList) {
        return success(connetRuleInfoService.saveAll(deviceConnetRuleInfoRespVOList));
    }


    @DeleteMapping("/deleteByRuleId")
    @Operation(summary = "根据RuleId删除访问规则配置")
    @Parameter(name = "id", description = "编号", required = true)
    public CommonResult<Boolean> deleteByRuleId(@RequestParam("ruleId") Long ruleId) {
        connetRuleInfoService.deleteByRuleId(ruleId);
        return success(true);
    }

    @PutMapping("/updateAll")
    @Operation(summary = "更新访问规则配置")
    public CommonResult<Boolean> updateAll(@Valid @RequestBody List<DeviceConnetRuleInfoRespVO> deviceConnetRuleInfoRespVOList) {
        return success(connetRuleInfoService.updateAll(deviceConnetRuleInfoRespVOList));
    }
}