package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - web请求配置新增/修改 Request VO")
@Data
public class WebReqConfSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30098")
    private Long id;

    @Schema(description = "系统简称中文")
    private String abbreCn;

    @Schema(description = "系统简称外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "19731")
    @NotNull(message = "系统简称外键不能为空")
    private Long abbreId;

    @Schema(description = "api地址", example = "https://www.iocoder.cn")
    private String apiUrl;

    @Schema(description = "api名称", example = "李四")
    private String apiName;

    @Schema(description = "父级id", example = "28717")
    private Long parentId;

    /**
     * 方位地址id
     */
    @Schema(description = "api父级id", example = "28718")
    private String apiId;
    /**
     * 访问地址父级id
     */
    @Schema(description = "访问地址父级id", example = "28719")
    private String apiParentId;
}