package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 访问规则配置新增/修改 Request VO")
@Data
public class VisitInfoSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31715")
    private Long id;

    @Schema(description = "规则表外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "10305")
    @NotNull(message = "规则表外键不能为空")
    private Long visitId;

    @Schema(description = "系统简称", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "系统简称不能为空")
    private String sysAbbre;

    @Schema(description = "系统名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "王五")
    @NotEmpty(message = "系统名称不能为空")
    private String sysAbbreName;

    @Schema(description = "菜单名称", example = "王五")
    private String urlName;

    @Schema(description = "菜单地址", example = "https://www.iocoder.cn")
    private String url;
    @Schema(description = "菜单地址Id", example = "https://www.iocoder.cn")
    private String urlId;

    @Schema(description = "角色id", example = "6818")
    private String roleId;

    @Schema(description = "角色名称", example = "李四")
    private String roleName;

    @Schema(description = "用户id", example = "31619")
    private String userId;

    @Schema(description = "用户名称", example = "王五")
    private String userName;

}