package cn.gintone.controller;

import cn.gintone.service.MySystemService;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.module.system.controller.admin.auth.vo.AuthPermissionInfoRespVO;
import cn.iocoder.yudao.module.system.dal.dataobject.permission.RoleDO;
import cn.iocoder.yudao.module.system.dal.dataobject.user.AdminUserDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/admin-api/gintone/MySystemController")
public class MySystemController {
    @Autowired
    private MySystemService mySystemService;

    @GetMapping("/getMenuBySysAbbre")
    public CommonResult<List<AuthPermissionInfoRespVO.MenuVO>> getMenuBySysAbbre(@RequestParam("sysAbbre") String sysAbbre) {
        List<AuthPermissionInfoRespVO.MenuVO> menuBySysAbbre = mySystemService.getMenuBySysAbbre(sysAbbre);
        return CommonResult.success(menuBySysAbbre);
    }

    @GetMapping("/getRoleBySysAbbre")
    public CommonResult<List<RoleDO>> getRoleBySysAbbre(@RequestParam("sysAbbre") String sysAbbre) {
        List<RoleDO> roleDOList = mySystemService.getRolesBySysAbbre(sysAbbre);
        return CommonResult.success(roleDOList);
    }

    @GetMapping("/getUserBySysAbbreAndRoleId")
    public CommonResult<List<AdminUserDO>> getUserBySysAbbreAndRoleId(@RequestParam("sysAbbre") String sysAbbre, @RequestParam("roleId") String roleId) {
        List<AdminUserDO> userDOList = mySystemService.getAdminUsersBySysAbbreAndRoleId(sysAbbre, roleId);
        return CommonResult.success(userDOList);
    }
}
