package cn.gintone.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class KafkaProducer {
    private final KafkaTemplate<String, String> kafkaTemplate;
    private static final String TOPIC = "weblog.save"; // 与消费者中配置的topic一致
    private static final String GROUP_ID = "weblog_consumer_group"; // 与消费者中配置的group一致，但不是必须的，除非你需要用它来做额外的配置或验证。通常在@KafkaListener中指定。

    @Autowired // 自动注入KafkaTemplate实例。默认的泛型参数是Key和Value的类型。这里都是String类型。根据需要可以更改。
    public KafkaProducer(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public void sendMessage(String message) {
        kafkaTemplate.send(TOPIC, message); // 发送消息到指定的topic。这里用的是默认分区器，可以根据需要传递key来指定分区。例如：kafkaTemplate.send(TOPIC, "key", message);。 默认分区器会根据key的哈希值来决定分区。如果不需要key，则可以省略它。 例如：kafkaTemplate.send(TOPIC, null, message); 或者直接使用上面的方法。 需要注意的是，如果使用了key，那么最好在整个系统中保持key的一致性，以便于消息的顺序处理和分区策略的正确执行。如果不确定key的使用场景，可以先省略它，之后再根据需要添加。例如： kafkaTemplate.send(TOPIC, message); 这样发送的消息会被均匀地分配到各个分区上，而没有特定的顺序保证。这对于大多数场景来说是足够的，特别是当不需要保证消息顺序时。如果要保证消息的顺序，可以考虑使用同一个key发送消息到同一个分区。例如： kafkaTemplate.send(TOPIC, "someKey", message); 这样发送的消息都会被分配到同一个分区上，保证了消息的顺序。但是要注意，这可能会影响消息的并行处理能力
    }
}