package cn.gintone.controller;

import cn.gintone.controller.vo.VisitInfoPageReqVO;
import cn.gintone.controller.vo.VisitInfoRespVO;
import cn.gintone.controller.vo.VisitInfoSaveReqVO;
import cn.gintone.entity.VisitInfoDO;
import cn.gintone.service.VisitInfoService;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.List;

import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;

@Tag(name = "管理后台 - 访问规则配置")
@RestController
@RequestMapping("/admin-api/visitInfo/visit-info")
@Validated
public class VisitInfoController {

    @Resource
    private VisitInfoService visitInfoService;

    @PostMapping("/create")
    @Operation(summary = "创建访问规则配置")
    public CommonResult<Long> createVisitInfo(@Valid @RequestBody VisitInfoSaveReqVO createReqVO) {
        return success(visitInfoService.createVisitInfo(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新访问规则配置")
    public CommonResult<Boolean> updateVisitInfo(@Valid @RequestBody VisitInfoSaveReqVO updateReqVO) {
        visitInfoService.updateVisitInfo(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除访问规则配置")
    @Parameter(name = "id", description = "编号", required = true)
    public CommonResult<Boolean> deleteVisitInfo(@RequestParam("id") Long id) {
        visitInfoService.deleteVisitInfo(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得访问规则配置")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    public CommonResult<VisitInfoRespVO> getVisitInfo(@RequestParam("id") Long id) {
        VisitInfoDO visitInfo = visitInfoService.getVisitInfo(id);
        return success(BeanUtils.toBean(visitInfo, VisitInfoRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得访问规则配置分页")
    public CommonResult<PageResult<VisitInfoRespVO>> getVisitInfoPage(@Valid VisitInfoPageReqVO pageReqVO) {
        PageResult<VisitInfoDO> pageResult = visitInfoService.getVisitInfoPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, VisitInfoRespVO.class));
    }

    @GetMapping("/getList")
    @Operation(summary = "获得访问规则配置")
    public CommonResult<List<VisitInfoDO>> getList(VisitInfoPageReqVO pageReqVO) {
        List<VisitInfoDO> list = visitInfoService.getList(pageReqVO);
        return success(list);
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出访问规则配置 Excel")
    @ApiAccessLog(operateType = EXPORT)
    public void exportVisitInfoExcel(@Valid VisitInfoPageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<VisitInfoDO> list = visitInfoService.getVisitInfoPage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "访问规则配置.xls", "数据", VisitInfoRespVO.class,
                        BeanUtils.toBean(list, VisitInfoRespVO.class));
    }


    @PostMapping("/saveAllVisitInfo")
    @Operation(summary = "创建访问规则配置")
    public CommonResult<Boolean> saveAllVisitInfo(@Valid @RequestBody List<VisitInfoSaveReqVO> visitInfoSaveReqVOList) {
        return success(visitInfoService.saveAllVisitInfo(visitInfoSaveReqVOList));
    }

    @DeleteMapping("/deleteByVisitId")
    @Operation(summary = "根据visitId删除访问规则配置")
    @Parameter(name = "id", description = "编号", required = true)
    public CommonResult<Boolean> deleteByVisitId(@RequestParam("visitId") Long visitId) {
        visitInfoService.deleteByVisitId(visitId);
        return success(true);
    }

    @PutMapping("/updateAllVisitInfo")
    @Operation(summary = "更新访问规则配置")
    public CommonResult<Boolean> updateAllVisitInfo(@Valid @RequestBody List<VisitInfoSaveReqVO> visitInfoSaveReqVOList) {
        return success(visitInfoService.updateAllVisitInfo(visitInfoSaveReqVOList));
    }
}