package cn.gintone.service;

import java.util.*;
import javax.validation.*;

import cn.gintone.controller.vo.PtUserInfoPageReqVO;
import cn.gintone.controller.vo.PtUserInfoSaveReqVO;
import cn.gintone.entity.PtUserInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;

/**
 * 平台用户 Service 接口
 *
 * @author 安全系统管理
 */
public interface PtUserInfoService {

    /**
     * 创建平台用户
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createPtUserInfo(@Valid PtUserInfoSaveReqVO createReqVO);

    /**
     * 更新平台用户
     *
     * @param updateReqVO 更新信息
     */
    void updatePtUserInfo(@Valid PtUserInfoSaveReqVO updateReqVO);

    /**
     * 删除平台用户
     *
     * @param id 编号
     */
    void deletePtUserInfo(Long id);

    /**
     * 获得平台用户
     *
     * @param id 编号
     * @return 平台用户
     */
    PtUserInfoDO getPtUserInfo(Long id);

    /**
     * 获得平台用户分页
     *
     * @param pageReqVO 分页查询
     * @return 平台用户分页
     */
    PageResult<PtUserInfoDO> getPtUserInfoPage(PtUserInfoPageReqVO pageReqVO);

    String syncPtUser();
}