package cn.gintone.dal;

import cn.gintone.controller.vo.KeyCodePageReqVO;
import cn.gintone.entity.KeyCodeDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 公钥私钥管理 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface KeyCodeMapper extends BaseMapperX<KeyCodeDO> {

    default PageResult<KeyCodeDO> selectPage(KeyCodePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<KeyCodeDO>()
                .eqIfPresent(KeyCodeDO::getType, reqVO.getType())
                .eqIfPresent(KeyCodeDO::getPublicKey, reqVO.getPublicKey())
                .eqIfPresent(KeyCodeDO::getPrivateKey, reqVO.getPrivateKey())
                .betweenIfPresent(KeyCodeDO::getCreateTime, reqVO.getCreateTime())
                .betweenIfPresent(KeyCodeDO::getUpdateTime, reqVO.getUpdateTime())
                .orderByDesc(KeyCodeDO::getId));
    }

}