package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 设备规则配置细则新增/修改 Request VO")
@Data
public class DeviceConnetRuleInfoSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18505")
    private Long id;

    @Schema(description = "规则外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "11033")
    @NotNull(message = "规则外键不能为空")
    private Long deviceRuleId;

    @Schema(description = "设备名称", example = "李四")
    private String deviceName;

    @Schema(description = "设备id", example = "10642")
    private String deviceId;

    @Schema(description = "角色", example = "9412")
    private String roleId;

    @Schema(description = "角色名称", example = "张三")
    private String roleName;

    @Schema(description = "用户id", example = "31481")
    private String userId;

    @Schema(description = "用户名称", example = "芋艿")
    private String userName;
    private String deviceSn; // 设备sn
}