package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 法人脱敏 Response VO")
@Data
@ExcelIgnoreUnannotated
public class DesCorporationRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30156")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "属性名称", example = "李四")
    @ExcelProperty("属性名称")
    private String name;

    @Schema(description = "属性描述")
    @ExcelProperty("属性描述")
    private String attr;

    @Schema(description = "配置1")
    @ExcelProperty("配置1")
    private String valueOne;

    @Schema(description = "配置2")
    @ExcelProperty("配置2")
    private String valueTwo;

    @Schema(description = "配置3")
    @ExcelProperty("配置3")
    private String valueThree;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "规则")
    @ExcelProperty("规则")
    private Integer rule;

}