package cn.gintone.service;

import cn.gintone.controller.vo.KeyCodePageReqVO;
import cn.gintone.controller.vo.KeyCodeSaveReqVO;
import cn.gintone.dto.EncInfo;
import cn.gintone.entity.KeyCodeDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;

/**
 * 公钥私钥管理 Service 接口
 *
 * @author 胡懿
 */
public interface KeyCodeService {

    /**
     * 创建公钥私钥管理
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createKeyCode(@Valid KeyCodeSaveReqVO createReqVO);

    /**
     * 更新公钥私钥管理
     *
     * @param updateReqVO 更新信息
     */
    void updateKeyCode(@Valid KeyCodeSaveReqVO updateReqVO);

    /**
     * 删除公钥私钥管理
     *
     * @param id 编号
     */
    void deleteKeyCode(Long id);

    /**
     * 获得公钥私钥管理
     *
     * @param id 编号
     * @return 公钥私钥管理
     */
    KeyCodeDO getKeyCode(Long id);

    /**
     * 获得公钥私钥管理分页
     *
     * @param pageReqVO 分页查询
     * @return 公钥私钥管理分页
     */
    PageResult<KeyCodeDO> getKeyCodePage(KeyCodePageReqVO pageReqVO);

    /**
     * 初始化公钥私钥
     * @return
     */
    String initKey();

    /**
     * 使用ras加密
     * @param info
     * @return
     */
    EncInfo rasEncryption(String info);

    String rasDecrypt(EncInfo encInfo);
}