package cn.gintone.iotdbUtils;

import cn.gintone.config.IotDbConfig;
import cn.gintone.dto.WebIllLogInfo;
import cn.gintone.dto.WebLogInfo;
import cn.gintone.dto.WebLogInfoVo;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.springframework.util.StringUtils;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public class MyIotDbUtils {
    private static SessionPool sessionPool;

    // 创建数据库
    public static void createDatabase(IotDbConfig iotDbConfig) {
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            sessionPool.createDatabase("root.myWebLogInfo"); // 创建数据库
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createWebLogInfoTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.sysAbbre", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.url", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.type", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }


    public static void createIllegalLogTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.sysAbbre", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.url", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.type", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.illType", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void inserOne(IotDbConfig iotDbConfig, WebLogInfo webLogInfo) {
        if (null == webLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            List<String> list5 = new ArrayList<>();
            list5.add("userId");
            list5.add("username");
            list5.add("sysAbbre");
            list5.add("url");
            list5.add("accessed");
            list5.add("type");
            list5.add("clientIp");
            list5.add("remark");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(webLogInfo.getUserId());
            values.add(webLogInfo.getUsername());
            values.add(webLogInfo.getSysAbbre());
            values.add(webLogInfo.getUrl());
            values.add(MyDateUtils.stringToLong(webLogInfo.getAccessed()));
            values.add(webLogInfo.getType());
            values.add(webLogInfo.getClientIp());
            values.add(webLogInfo.getRemark());
            sessionPool.insertRecord("root.myWebLogInfo.tableThree", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    // 单行插入
    public static void inserOne_Ill(IotDbConfig iotDbConfig, WebIllLogInfo webIllLogInfo) {
        if (null == webIllLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            List<String> list5 = new ArrayList<>();
            list5.add("userId");
            list5.add("username");
            list5.add("sysAbbre");
            list5.add("url");
            list5.add("accessed");
            list5.add("type");
            list5.add("clientIp");
            list5.add("remark");
            list5.add("illType");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(webIllLogInfo.getUserId());
            values.add(webIllLogInfo.getUsername());
            values.add(webIllLogInfo.getSysAbbre());
            values.add(webIllLogInfo.getUrl());
            values.add(MyDateUtils.stringToLong(webIllLogInfo.getAccessed()));
            values.add(webIllLogInfo.getType());
            values.add(webIllLogInfo.getClientIp());
            values.add(webIllLogInfo.getRemark());
            values.add(webIllLogInfo.getIllType());
            sessionPool.insertRecord("root.myWebLogInfo.tableThree", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }


    // 查询总条数
    public static long countWebInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myWebLogInfo.tableTwo");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    // 查询列表
    public static List<WebLogInfo> selectWebInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        List<WebLogInfo> webLogInfos = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (webLogInfoVo.getPageNum() - 1) * webLogInfoVo.getPageSize() + 1;
            int limitNum = webLogInfoVo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select userId, username, sysAbbre, url, accessed, type, clientIp, remark from root.myWebLogInfo.tableTwo");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String userId = field0.getStringValue();
                Field field1 = fields.get(1);
                String username = field1.getStringValue();
                Field field2 = fields.get(2);
                String sysAbbre = field2.getStringValue();
                Field field3 = fields.get(3);
                String url = field3.getStringValue();
                Field field4 = fields.get(4);
                long accessed = field4.getLongV();
                Field field5 = fields.get(5);
                String type = field5.getStringValue();
                Field field6 = fields.get(6);
                String clientIp = field6.getStringValue();
                Field field7 = fields.get(7);
                String remark = field7.getStringValue();

                WebLogInfo webLogInfo = new WebLogInfo();
                webLogInfo.setTimesta(timestamp);
                webLogInfo.setTimestaStr(MyDateUtils.longToString(timestamp));
                webLogInfo.setUserId(userId);
                webLogInfo.setUsername(username);
                webLogInfo.setSysAbbre(sysAbbre);
                webLogInfo.setUrl(url);
                webLogInfo.setAccessed(MyDateUtils.longToString(accessed));
                webLogInfo.setType(type);
                webLogInfo.setClientIp(clientIp);
                webLogInfo.setRemark(remark);
                webLogInfos.add(webLogInfo);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return webLogInfos;
    }


    // 查询总条数
    public static long countWebIllInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myWebLogInfo.tableThree");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
                if (null != webLogInfoVo.getIllType() && !"".equals(webLogInfoVo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" illType = " + "'" +webLogInfoVo.getIllType() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    public static List<WebIllLogInfo> selectWebIllInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        List<WebIllLogInfo> webIllLogInfos = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (webLogInfoVo.getPageNum() - 1) * webLogInfoVo.getPageSize() + 1;
            int limitNum = webLogInfoVo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select userId, username, sysAbbre, url, accessed, type, clientIp, remark, illType from root.myWebLogInfo.tableThree");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
                if (null != webLogInfoVo.getIllType() && !"".equals(webLogInfoVo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" illType = " + "'" +webLogInfoVo.getIllType() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String userId = field0.getStringValue();
                Field field1 = fields.get(1);
                String username = field1.getStringValue();
                Field field2 = fields.get(2);
                String sysAbbre = field2.getStringValue();
                Field field3 = fields.get(3);
                String url = field3.getStringValue();
                Field field4 = fields.get(4);
                long accessed = field4.getLongV();
                Field field5 = fields.get(5);
                String type = field5.getStringValue();
                Field field6 = fields.get(6);
                String clientIp = field6.getStringValue();
                Field field7 = fields.get(7);
                String remark = field7.getStringValue();
                Field field8 = fields.get(8);
                String illType = field8.getStringValue();

                WebIllLogInfo webIllLogInfo = new WebIllLogInfo();
                webIllLogInfo.setTimesta(timestamp);
                webIllLogInfo.setTimestaStr(MyDateUtils.longToString(timestamp));
                webIllLogInfo.setUserId(userId);
                webIllLogInfo.setUsername(username);
                webIllLogInfo.setSysAbbre(sysAbbre);
                webIllLogInfo.setUrl(url);
                webIllLogInfo.setAccessed(MyDateUtils.longToString(accessed));
                webIllLogInfo.setType(type);
                webIllLogInfo.setClientIp(clientIp);
                webIllLogInfo.setRemark(remark);
                webIllLogInfo.setIllType(illType);
                webIllLogInfos.add(webIllLogInfo);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return webIllLogInfos;
    }
}
