package cn.gintone.service;

import cn.gintone.controller.vo.VisitPageReqVO;
import cn.gintone.controller.vo.VisitSaveReqVO;
import cn.gintone.entity.VisitDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;

/**
 * 接口安全访问策略 Service 接口
 *
 * @author 胡懿
 */
public interface VisitService {

    /**
     * 创建接口安全访问策略
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createVisit(@Valid VisitSaveReqVO createReqVO);

    /**
     * 更新接口安全访问策略
     *
     * @param updateReqVO 更新信息
     */
    void updateVisit(@Valid VisitSaveReqVO updateReqVO);

    /**
     * 删除接口安全访问策略
     *
     * @param id 编号
     */
    void deleteVisit(Long id);

    /**
     * 获得接口安全访问策略
     *
     * @param id 编号
     * @return 接口安全访问策略
     */
    VisitDO getVisit(Long id);

    /**
     * 获得接口安全访问策略分页
     *
     * @param pageReqVO 分页查询
     * @return 接口安全访问策略分页
     */
    PageResult<VisitDO> getVisitPage(VisitPageReqVO pageReqVO);

}