package cn.gintone.service;

import cn.gintone.controller.vo.VisitInfoPageReqVO;
import cn.gintone.controller.vo.VisitInfoRespVO;
import cn.gintone.controller.vo.VisitInfoSaveReqVO;
import cn.gintone.dto.WebLogInfo;
import cn.gintone.entity.VisitInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;
import java.util.List;

/**
 * 访问规则配置 Service 接口
 *
 * @author 胡懿
 */
public interface VisitInfoService {

    /**
     * 创建访问规则配置
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createVisitInfo(@Valid VisitInfoSaveReqVO createReqVO);

    /**
     * 更新访问规则配置
     *
     * @param updateReqVO 更新信息
     */
    void updateVisitInfo(@Valid VisitInfoSaveReqVO updateReqVO);

    /**
     * 删除访问规则配置
     *
     * @param id 编号
     */
    void deleteVisitInfo(Long id);

    /**
     * 获得访问规则配置
     *
     * @param id 编号
     * @return 访问规则配置
     */
    VisitInfoDO getVisitInfo(Long id);

    /**
     * 获得访问规则配置分页
     *
     * @param pageReqVO 分页查询
     * @return 访问规则配置分页
     */
    PageResult<VisitInfoDO> getVisitInfoPage(VisitInfoPageReqVO pageReqVO);
    List<VisitInfoDO> getList(VisitInfoPageReqVO reqVo);

    Boolean saveAllVisitInfo(List<VisitInfoSaveReqVO> visitInfoSaveReqVOList);

    void deleteByVisitId(Long visitId);

    boolean updateAllVisitInfo(List<VisitInfoSaveReqVO> visitInfoSaveReqVOList);

    void checkWebLogInfo(WebLogInfo webLogInfo);
}