package cn.gintone.service;

import cn.gintone.controller.vo.UserDesRulePageReqVO;
import cn.gintone.controller.vo.UserDesRuleSaveReqVO;
import cn.gintone.entity.UserDesRuleDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;
import java.util.List;
import java.util.Map;

/**
 * 人员脱敏规则 Service 接口
 *
 * @author 胡懿
 */
public interface UserDesRuleService {

    /**
     * 创建人员脱敏规则
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createUserDesRule(@Valid UserDesRuleSaveReqVO createReqVO);

    /**
     * 更新人员脱敏规则
     *
     * @param updateReqVO 更新信息
     */
    void updateUserDesRule(@Valid UserDesRuleSaveReqVO updateReqVO);

    /**
     * 删除人员脱敏规则
     *
     * @param id 编号
     */
    void deleteUserDesRule(Long id);

    /**
     * 获得人员脱敏规则
     *
     * @param id 编号
     * @return 人员脱敏规则
     */
    UserDesRuleDO getUserDesRule(Long id);

    /**
     * 获得人员脱敏规则分页
     *
     * @param pageReqVO 分页查询
     * @return 人员脱敏规则分页
     */
    PageResult<UserDesRuleDO> getUserDesRulePage(UserDesRulePageReqVO pageReqVO);

    String userRuleDes(String userJsonStr);

    String userRuleDesArr(String userJsonArrStr);

    Boolean checkName(String name, Long id);

    Map<String, Object> userRuleDesMap(Map<String, Object> map);

    List<Map<String, Object>> userRuleDesListMap(List<Map<String, Object>> lisetMap);
}