package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.MyTablePageReqVO;
import cn.gintone.controller.vo.MyTableSaveReqVO;
import cn.gintone.dal.MyTableMapper;
import cn.gintone.entity.MyTableDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;


import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 我的测试表 Service 实现类
 *
 * @author 胡懿
 */
@Service
@Validated
public class MyTableServiceImpl implements MyTableService {

    @Resource
    private MyTableMapper myTableMapper;

    @Override
    public Long createMyTable(MyTableSaveReqVO createReqVO) {
        // 插入
        MyTableDO myTable = BeanUtils.toBean(createReqVO, MyTableDO.class);
        myTableMapper.insert(myTable);
        // 返回
        return myTable.getId();
    }

    @Override
    public void updateMyTable(MyTableSaveReqVO updateReqVO) {
        // 校验存在
        validateMyTableExists(updateReqVO.getId());
        // 更新
        MyTableDO updateObj = BeanUtils.toBean(updateReqVO, MyTableDO.class);
        myTableMapper.updateById(updateObj);
    }

    @Override
    public void deleteMyTable(Long id) {
        // 校验存在
        validateMyTableExists(id);
        // 删除
        myTableMapper.deleteById(id);
    }

    private void validateMyTableExists(Long id) {
        if (myTableMapper.selectById(id) == null) {
            throw exception(ErrorInfo.MY_TABLE_NOT_EXISTS);
        }
    }

    @Override
    public MyTableDO getMyTable(Long id) {
        return myTableMapper.selectById(id);
    }

    @Override
    public PageResult<MyTableDO> getMyTablePage(MyTablePageReqVO pageReqVO) {
        return myTableMapper.selectPage(pageReqVO);
    }

}