package cn.gintone.service;

import cn.gintone.controller.vo.MyTablePageReqVO;
import cn.gintone.controller.vo.MyTableSaveReqVO;
import cn.gintone.entity.MyTableDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import java.util.*;
import javax.validation.*;

/**
 * 我的测试表 Service 接口
 *
 * @author 胡懿
 */
public interface MyTableService {

    /**
     * 创建我的测试表
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createMyTable(@Valid MyTableSaveReqVO createReqVO);

    /**
     * 更新我的测试表
     *
     * @param updateReqVO 更新信息
     */
    void updateMyTable(@Valid MyTableSaveReqVO updateReqVO);

    /**
     * 删除我的测试表
     *
     * @param id 编号
     */
    void deleteMyTable(Long id);

    /**
     * 获得我的测试表
     *
     * @param id 编号
     * @return 我的测试表
     */
    MyTableDO getMyTable(Long id);

    /**
     * 获得我的测试表分页
     *
     * @param pageReqVO 分页查询
     * @return 我的测试表分页
     */
    PageResult<MyTableDO> getMyTablePage(MyTablePageReqVO pageReqVO);

}