package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.ImportantFilePageReqVO;
import cn.gintone.controller.vo.ImportantFileSaveReqVO;
import cn.gintone.dal.ImportantFileMapper;
import cn.gintone.entity.ImportantFileDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;


import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 重要文件 Service 实现类
 *
 * @author 胡懿
 */
@Service
@Validated
public class ImportantFileServiceImpl implements ImportantFileService {

    @Resource
    private ImportantFileMapper importantFileMapper;

    @Override
    public Long createImportantFile(ImportantFileSaveReqVO createReqVO) {
        // 插入
        ImportantFileDO importantFile = BeanUtils.toBean(createReqVO, ImportantFileDO.class);
        importantFileMapper.insert(importantFile);
        // 返回
        return importantFile.getId();
    }

    @Override
    public void updateImportantFile(ImportantFileSaveReqVO updateReqVO) {
        // 校验存在
        validateImportantFileExists(updateReqVO.getId());
        // 更新
        ImportantFileDO updateObj = BeanUtils.toBean(updateReqVO, ImportantFileDO.class);
        importantFileMapper.updateById(updateObj);
    }

    @Override
    public void deleteImportantFile(Long id) {
        // 校验存在
        validateImportantFileExists(id);
        // 删除
        importantFileMapper.deleteById(id);
    }

    private void validateImportantFileExists(Long id) {
        if (importantFileMapper.selectById(id) == null) {
            throw exception(ErrorInfo.IMPORTANT_FILE_NOT_EXISTS);
        }
    }

    @Override
    public ImportantFileDO getImportantFile(Long id) {
        return importantFileMapper.selectById(id);
    }

    @Override
    public PageResult<ImportantFileDO> getImportantFilePage(ImportantFilePageReqVO pageReqVO) {
        return importantFileMapper.selectPage(pageReqVO);
    }

}